package gov.va.genisis2.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * The Class CommentType.
 * 
 * Description: In this CommentType Class implements the interface Serializable
 * and defines the entity and data mapping for the dbo.CommentType Table in the
 * database.
 */
@Entity
@Table(name = "CommentType", schema = "dbo")
public class CommentType implements Serializable {
	
	private static final long serialVersionUID = -1896535629021678295L;

	/** The id. */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	private int id;
	
	/** The description. */
	@Column(name = "Description", length = 50)
	private String description;

	/** The comment histories. */
	@OneToMany(fetch = FetchType.EAGER, mappedBy = "commentType")
	private Set<CommentHistory> commentHistories = new HashSet<>(0);

	public int getId() {
		return this.id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the commentHistories
	 */
	public Set<CommentHistory> getCommentHistories() {
		return commentHistories;
	}

	/**
	 * @param commentHistories
	 *            the commentHistories to set
	 */
	public void setCommentHistories(Set<CommentHistory> commentHistories) {
		this.commentHistories = commentHistories;
	}

}
